import std.c.windows.windows;

extern (C) int system (char*);

extern (Windows) BOOL QueryPerformanceFrequency(ulong* lpFrequency);
extern (Windows) BOOL QueryPerformanceCounter(ulong * lpFrequency);

ulong elapsedTimeCounter;

ulong elapsedTime ()
{
    ulong freq, value;

    if (!QueryPerformanceFrequency (&freq) || freq == 0 || !QueryPerformanceCounter (&value))
        return GetTickCount () * 1000;
    if (!elapsedTimeCounter)
        elapsedTimeCounter = value;
    return (value - elapsedTimeCounter) * 1000000 / freq;
}

extern (C) int spawnvp (int, char *, char **);
extern (C) void exit (int);

int main (char [] [] args)
{
    char [] command;
    ulong start, end;
    char *[] argv;
    int result;

    for (int c = 1; c < args.length; c ++)
        argv ~= args [c];

    start = elapsedTime ();
    result = spawnvp (0, args [1], argv);
    end = elapsedTime ();

    if (result)
        printf ("%d returned.\n", result);
    printf ("%.6f seconds.\n", (double) (end - start) / 1000000.0);
    printf ("%.3f milliseconds.\n", (double) (end - start) / 1000.0);
    printf (" %d microseconds.\n", (int) (end - start));
    return result;
}